#include "testlib.h"
#include <bits/stdc++.h>

using namespace std;
 
static const std::string input_secret = "3905dde5ebb4c3c616c4aecc3a7e1801ce17df70";
static const std::string output_secret = "11aafa73e7e6b339b273565a5bb47429";
static const std::string error_secret = "64be09ab-d709-ERROR-82bc-c23f6124dd26";

int main(int argc, char *argv[]) {
	registerTestlibCmd(argc, argv);
	
	std::string secret = ouf.readLine();
	if (secret == error_secret) {
	    std::string msg = ouf.readLine();
	    quit(_wa, msg);
	}
	if (secret != output_secret) {
	    quit(_wa, "Security violation [37]");
	}
	
	int tests = ouf.readInt();
    bool is_full_score = true;
    bool less_or_eq_half = true;
    int max_ratio = 0;

    for(int test = 0; test < tests; test++){
        int n = ouf.readInt();
        int K = ouf.readInt();
        if(K >= 2*n) is_full_score = false;
        if(2*(K-1) > n*n) less_or_eq_half = false;
        max_ratio = max(max_ratio, (K+n-1)/n);
    }
    if (is_full_score) {
        quitf(_ok, "Correct");
    }    
    else if (max_ratio <= 10) {
        quitp((110 - max_ratio * 9) * 0.01 , "Incorrect, max_ratio = %d", max_ratio);
    }
    else if(less_or_eq_half){
        quitp(0.07 , "Incorrect, max_ratio = %d", max_ratio);
    }
    else {
        quitf(_wa, "Incorrect, max_ratio = %d", max_ratio);
    }
}
