/*
 * 다음과 같은 과정으로 채점된다고 가정해도 좋습니다.
 *
 * Pass 1:  ./railroad < %03d.in.txt > output1.txt
 * Pass 2:  ./railroad < output1.txt > output2.txt
 * Checker: ./checker %03d.in.txt output2.txt answer.txt
 */

#include <bits/stdc++.h>

#include "grid_encoding.h"
#define si(x) (int)(x.size())
#define all(v) (v).begin(), (v).end()
using namespace std;
using pii = pair<int,int>;

static int N;
static vector<pair<int,int>> cells;

static const std::string input_secret = "3905dde5ebb4c3c616c4aecc3a7e1801ce17df70";
static const std::string interactor_secret = "d3b2d22d83a3562bdeed51c04fea59d39d2aa5f0";
static const std::string output_secret = "11aafa73e7e6b339b273565a5bb47429";
static const std::string error_secret = "64be09ab-d709-ERROR-82bc-c23f6124dd26";

void ensure(bool p, const char *err) {
	if (!p) {
	    cout << error_secret << "\n";
		cout << err << endl;
		exit(0);
	}
}

void select(int x, int y){
	ensure(0 <= x && x < N && 0 <= y && y < N, "Wrong Answer [1]");
	cells.push_back({x,y});
	ensure(si(cells) <= N*N, "Wrong Answer [2]");
}

struct testdata{
    int N, K;
    vector<vector<int>> A, B, C;
    vector<int> X, Y;
};


int main(){

	ios_base::sync_with_stdio(0);
	cin.tie(0);
	cout.tie(0);

    string secret;
    int run, tests;
    cin >> secret;
    if(secret == error_secret){
        ensure (false, "Wrong Answer on first run");
    }
    cin >> run >> tests;


    if(run == 1) { // first run
        ensure (secret == input_secret, "input secret is wrong?");
        vector<testdata> data(tests);
        for(int test=0;test<tests;test++){
            cin >> N;
            vector<vector<int>>A(N,vector<int>(N));
            for(int i=0;i<N;i++){
                for(int j=0;j<N;j++){
                    cin >> A[i][j];
                }
            }
            vector<int>X(N), Y(N);
            for(int i=0;i<N;i++){
                cin >> X[i];
            }
            for(int i=0;i<N;i++){
                cin >> Y[i];
            }

            cells.clear();
            send(A);

            data[test].N = N;
            data[test].A = A;
            data[test].X = X;
            data[test].Y = Y;
            data[test].K = si(cells);
            vector<vector<int>>B(N,vector<int>(N));
            vector<vector<int>>C(N,vector<int>(N));

            for(int i=0;i<N;i++){
                for(int j=0;j<N;j++){
                    B[i][j] = -1;
                    C[X[i]][Y[j]] = A[i][j];
                }
            }
            for(auto &[x,y] : cells){
                B[X[x]][Y[y]] = A[x][y];
            }
            data[test].B = B;
            data[test].C = C;
        }
        cout << interactor_secret << "\n";
        cout << 2 << " " << tests << "\n"; //run, tests for second run
        for(int test=0;test<tests;test++){
            cout << data[test].N << " " << data[test].K << "\n";
            for(int i=0;i<data[test].N;i++){
                for(int j=0;j<data[test].N;j++){
                    cout << data[test].B[i][j] << " ";
                }
                cout << "\n";
            }
            for(int i=0;i<data[test].N;i++){
                for(int j=0;j<data[test].N;j++){
                    cout << data[test].C[i][j] << " ";
                }
                cout << "\n";
            }
        }
    }

    if(run == 2) { // second run
        ensure (secret == interactor_secret, "interactor secret is wrong?");

        vector<pii> output_log;
        for(int test=0;test<tests;test++){
            int K;
            cin >> N >> K;
            vector<vector<int>>B(N,vector<int>(N));
            vector<vector<int>>C(N,vector<int>(N));
            for(int i=0;i<N;i++){
                for(int j=0;j<N;j++){
                    cin >> B[i][j];
                }
            }
            for(int i=0;i<N;i++){
                for(int j=0;j<N;j++){
                    cin >> C[i][j];
                }
            }
            auto res = reconstruct(B);
            ensure(si(res) == N, "Wrong Answer [3]");
            for(int i=0;i<N;i++){
                ensure(si(res[i]) == N, "Wrong Answer [3]");
            }

            for(int i=0;i<N;i++){
                for(int j=0;j<N;j++){
                    ensure(res[i][j] == C[i][j], "Wrong Answer [4]");
                }
            }
            output_log.push_back({N,K});
        }
        cout << output_secret << "\n";
        cout << tests << "\n";
        for(int test=0;test<tests;test++){
            cout << output_log[test].first << " " << output_log[test].second << "\n";
        }
    }


	return 0;
}
